/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.KnownServerRegistries;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancementTask
extends BooleanTask {
    public ResourceLocation advancement = new ResourceLocation("minecraft:story/root");
    public String criterion = "";

    public AdvancementTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.ADVANCEMENT;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("advancement", this.advancement.toString());
        nbt.func_74778_a("criterion", this.criterion);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.advancement = new ResourceLocation(nbt.func_74779_i("advancement"));
        this.criterion = nbt.func_74779_i("criterion");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_192572_a(this.advancement);
        buffer.func_211400_a(this.criterion, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.advancement = buffer.func_192575_l();
        this.criterion = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        if (KnownServerRegistries.client != null && !KnownServerRegistries.client.advancements.isEmpty()) {
            Map advancements = KnownServerRegistries.client.advancements;
            KnownServerRegistries.AdvancementInfo def = (KnownServerRegistries.AdvancementInfo)advancements.values().iterator().next();
            config.addEnum("advancement", (Object)this.advancement, v -> {
                this.advancement = v;
            }, NameMap.of((Object)def.id, (Object[])advancements.keySet().toArray(new ResourceLocation[0])).icon(id -> ItemIcon.getItemIcon((ItemStack)KnownServerRegistries.client.advancements.getOrDefault((Object)id, def).icon)).name(id -> KnownServerRegistries.client.advancements.getOrDefault((Object)id, def).name).create()).setNameKey("ftbquests.task.ftbquests.advancement");
        } else {
            config.addString("advancement", this.advancement.toString(), v -> {
                this.advancement = new ResourceLocation(v);
            }, "minecraft:story/root").setNameKey("ftbquests.task.ftbquests.advancement");
        }
        config.addString("criterion", this.criterion, v -> {
            this.criterion = v;
        }, "");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getAltTitle() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get(this.advancement);
        if (info != null && info.name != StringTextComponent.field_240750_d_) {
            return new TranslationTextComponent("ftbquests.task.ftbquests.advancement").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent("").func_230529_a_(info.name).func_240699_a_(TextFormatting.YELLOW));
        }
        return super.getAltTitle();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get(this.advancement);
        if (info != null && !info.icon.func_190926_b()) {
            return ItemIcon.getItemIcon((ItemStack)info.icon);
        }
        return super.getAltIcon();
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 5;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayerEntity player) {
        Advancement a = player.field_71133_b.func_191949_aK().func_192778_a(this.advancement);
        if (a == null) {
            return false;
        }
        AdvancementProgress progress = player.func_192039_O().func_192747_a(a);
        if (this.criterion.isEmpty()) {
            return progress.func_192105_a();
        }
        CriterionProgress criterionProgress = progress.func_192106_c(this.criterion);
        return criterionProgress != null && criterionProgress.func_192151_a();
    }
}

